unit uMessReceiver;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, uMessageCommons, Winsock;

type
  TfrmMessageReceiver = class(TForm)
    mmText: TMemo;
    imPicture: TImage;
    edInteger: TEdit;
    Timer1: TTimer;
    procedure Timer1Timer(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
    FSocket: THandle;
    procedure ReceiveData(aData: TMemoryStream);
  public
    { Public declarations }
  end;

var
  frmMessageReceiver: TfrmMessageReceiver;
  fwsaData:WSADATA;

implementation

{$R *.DFM}

{ TfrmMessageReceiver }

procedure TfrmMessageReceiver.ReceiveData(aData: TMemoryStream);
var
  _int: integer;
  _str: string;
  _ln: integer;
begin
   { read the data type }
   aData.Read(_int, SizeOf(integer));

   case TMessageType(_int) of

      mtInteger:
         begin
            { read an integer }
            aData.Read(_int, SizeOf(integer));
            { display it }
            edInteger.Text:= IntToStr(_int);
         end;

      mtString:
         begin
            { calculate the string length }
            _ln:= aData.Size - SizeOf(integer); 
            SetLength(_str, _ln);
            { read the string }
            if (_ln > 0) then
               aData.Read(_str[1], _ln);
            { display it }
            mmText.Text:= _str;
         end;

      mtImage:
         begin
            { load and display the bitmap }
            imPicture.Picture.Bitmap.LoadFromStream(aData);
         end;
   end;
end;

procedure TfrmMessageReceiver.Timer1Timer(Sender: TObject);
var
   _s: string;
   _sz: integer;
   _remote: TSockAddr;
   _ret: integer;
   _ms: TMemoryStream;
begin
   if IoctlSocket(FSocket, FIONREAD, u_long(_sz)) = 0 then
      SetLength(_s, _sz);
   if (_sz = 0) then
      exit;

   _sz:= SIZEOF(_remote);
   _ret:= recvfrom(FSocket, _s[1], length(_s), 0, _remote, _sz);
   { did we got anything ? }
   if (_ret > 0) then
      SetLength(_s, _ret)
   else
      raise Exception.Create('failed to read data');

   _ms:= TMemoryStream.Create;
   try
      { write the msg data }
      _ms.Write(_s[1], length(_s));
      { go to begining of the file }
      _ms.Position:= 0;

      { decode the stream }
      ReceiveData(_ms);
   finally
      _ms.Free;
   end;
end;

procedure TfrmMessageReceiver.FormCreate(Sender: TObject);
var
   _local: TSockAddr;
begin
   FSocket:= socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
   if (FSocket = INVALID_SOCKET) then
      raise Exception.CreateFmt('Failed to CREATE the socket. Error: "%d"', [WSAGetLastError()]);
   _local.sin_family:= AF_INET;
   _local.sin_addr.s_addr:= INADDR_ANY;
   _local.sin_port:= htons(1111);
   if (bind(FSocket, _local, sizeof(_local)) = SOCKET_ERROR) then
      raise Exception.CreateFmt('Failed to BIND the socket. Error: "%d"', [WSAGetLastError()]);
end;

procedure TfrmMessageReceiver.FormDestroy(Sender: TObject);
begin
  if (FSocket <> INVALID_SOCKET) then
    if (shutdown(FSocket,2) = 0) then
      CloseSocket(FSocket);

end;

initialization
   if (WSAStartup ($0101, fWsaData)<>0) then
      raise Exception.Create('Failed to initialize winsock');

finalization
   WSACleanup;
   
end.
